<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('host_nodes', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description')->nullable();
            $table->string('ip_address')->unique();
            $table->string('ssh_username');
            $table->string('ssh_password')->nullable();
            $table->text('ssh_key')->nullable();
            $table->integer('ssh_port')->default(22);
            $table->integer('agent_port')->default(1515);
            $table->string('auth_key');
            $table->enum('status', ['active', 'inactive', 'installing', 'error'])->default('installing');
            $table->timestamp('last_checked_at')->nullable();
            $table->string('agent_version')->nullable();
            $table->string('libvirt_version')->nullable();
            $table->string('qemu_version')->nullable();
            $table->boolean('is_available')->default(true);
            $table->integer('total_memory')->default(0); // В МБ
            $table->integer('free_memory')->default(0);  // В МБ
            $table->integer('total_disk')->default(0);   // В ГБ
            $table->integer('free_disk')->default(0);    // В ГБ
            $table->boolean('is_locked')->default(false); // Закрыта для размещения
            $table->boolean('is_technical')->default(false); // Пометка что техничская
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('host_nodes');
    }
};
