<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Queue\Events\JobFailed;
use Illuminate\Queue\Events\JobProcessed;
use Illuminate\Queue\Events\JobProcessing;
use App\Listeners\JobFailedListener;
use App\Listeners\JobProcessedListener;
use App\Listeners\JobProcessingListener;

class AppServiceProvider extends ServiceProvider
{

    protected $listen = [
        JobProcessing::class => [
            JobProcessingListener::class,
        ],
        JobProcessed::class => [
            JobProcessedListener::class,
        ],
        JobFailed::class => [
            JobFailedListener::class,
        ],
    ];
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }

    protected $policies = [
        \App\Models\Node::class => \App\Policies\NodePolicy::class,
    ];

    // Пользователь должен иметь право "view-nodes"
    //return $user->hasPermission('view-nodes');

}
