<?php

namespace App\Policies;

use App\Models\HostNode;
use App\Models\User;

class NodePolicy
{
    public function view(User $user, HostNode $node)
    {
        return $user->hasPermission('view-nodes');
    }

    public function update(User $user, HostNode $node)
    {
        return $user->hasPermission('edit-nodes');
    }

    public function delete(User $user, HostNode $node)
    {
        return $user->hasPermission('delete-nodes');
    }

    public function createOnTechnicalNodes(User $user)
    {
        // Условие для проверки, имеет ли пользователь права на создание на технических нодах
        return $user->hasRole('admin'); // или другой метод проверки роли
    }

}
