<?php

namespace App\Notifications;

use Illuminate\Notifications\Notification;

class NodeUnavailableNotification extends Notification
{
    public function via($notifiable)
    {
        return ['database', 'mail']; // Если нужно уведомление по почте или в БД
    }

    public function toArray($notifiable)
    {
        return [
            'message' => 'Node ' . $this->hostNode->name . ' is unavailable.',
            'node_id' => $this->hostNode->id,
        ];
    }
}

