<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\VirtualMachine;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class VmStats extends Model
{
    use HasFactory;

    protected $fillable = [
        'vm_id',
        'cpu_usage',
        'memory_usage',
        'disk_read_bytes',
        'disk_write_bytes',
        'network_in_bytes',
        'network_out_bytes',
        'collected_at',
    ];

    protected $casts = [
        'collected_at' => 'datetime',
    ];

    public function virtualMachine() : BelongsTo
    {
        return $this->belongsTo(VirtualMachine::class, 'vm_id');
    }
}
