<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Pool;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class VirtualMachineTemplate extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'cpu',
        'memory',
        'disk_size',
        'snapshot_limit',
        'network_bridge',
        'network_model',
        'cpu_weight',
        'io_weight',
        'cpu_emulation',
        'network_in',
        'network_out',
        'storage_pool_id',
    ];

    public function storagePool() : BelongsTo
    {
        return $this->belongsTo(Pool::class, 'storage_pool_id');
    }
}
