<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\Repository;

class TemplateOs extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'icon', 'repository_link', 'archive_name', 'status'];

    public function repository() : BelongsTo
    {
        return $this->belongsTo(Repository::class, 'repository_link', 'url');
    }

}
