<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use App\Models\TemplateOs;

class Repository extends Model
{
    use HasFactory;

    protected $fillable = [
        'url',
        'description'
    ];

    public function templateOS() : HasMany
    {
        return $this->hasMany(TemplateOS::class);
    }

    // Метод для получения данных из info.json
    public function getOsListFromInfoJson()
    {
        $json = file_get_contents($this->url . '/info.json');
        return json_decode($json, true);
    }
}
