<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\HostNode;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class NodeStats extends Model
{
    use HasFactory;

    protected $fillable = [
        'node_id',
        'cpu_usage',
        'memory_usage',
        'collected_at',
    ];

    protected $casts = [
        'collected_at' => 'datetime',
    ];

    public function hostNode() : BelongsTo
    {
        return $this->belongsTo(HostNode::class, 'node_id');
    }

}
