<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\VirtualMachine;

class NetworkInterfaces extends Model
{
    use HasFactory;

    protected $fillable = [
        'mac_address',
        'virtual_machine_id',
    ];

    public function virtualMachine() : BelongsTo
    {
        return $this->belongsTo(VirtualMachine::class);
    }

    public static function generateMacAddress()
    {
        return sprintf(
            '52:54:%02X:%02X:%02X:%02X',
            rand(0, 255),
            rand(0, 255),
            rand(0, 255),
            rand(0, 255)
        );
    }
}
