<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\VirtualMachine;

class IsoImage extends Model
{
    use HasFactory;

    protected $fillable = [
        'virtual_machine_id',
        'iso_path',
    ];

    public function virtualMachine() : BelongsTo
    {
        return $this->belongsTo(VirtualMachine::class, 'virtual_machine_id');
    }

}
