<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use App\Models\VirtualMachine;
use App\Models\NodeStats;

class HostNode extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'ip_address',
        'ssh_username',
        'ssh_password',
        'ssh_key',
        'ssh_port',
        'auth_key',
        'agent_port',
        'status',
        'last_checked_at',
        'agent_version',
        'libvirt_version',
        'qemu_version',
        'is_available',
        'is_locked',
        'is_technical',
    ];

    public function virtualMachines() : HasMany
    {
        return $this->hasMany(VirtualMachine::class);
    }

    public function stats() : HasMany
    {
        return $this->hasMany(NodeStats::class, 'node_id');
    }
}
//Сбор данных: Вы можете использовать созданные модели VmStats и NodeStats для записи и получения статистики. Например, для получения средней загрузки процессора и памяти за день:
//
//$today = Carbon::today();
//
//$vmStats = VmStats::whereDate('collected_at', $today)
//    ->selectRaw('AVG(cpu_usage) as avg_cpu, AVG(memory_usage) as avg_memory')
//    ->first();
//
//$nodeStats = NodeStats::whereDate('collected_at', $today)
//    ->selectRaw('AVG(cpu_usage) as avg_cpu, AVG(memory_usage) as avg_memory')
//    ->first();
