<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\VirtualMachine;
use App\Models\HostNode;

class Disk extends Model
{
    use HasFactory;

    protected $fillable = [
        'virtual_machine_id',
        'host_node_id',
        'size',
        'path',
        'type',
        'status',
    ];

    public function virtualMachine() : BelongsTo
    {
        return $this->belongsTo(VirtualMachine::class);
    }

    public function hostNode() : BelongsTo
    {
        return $this->belongsTo(HostNode::class);
    }

}
