<?php

namespace App\Listeners;

use Illuminate\Queue\Events\JobProcessed;
use App\Models\JobMonitoring;

class JobProcessedListener
{
    public function handle(JobProcessed $event)
    {
        JobMonitoring::where('job_name', $event->job->resolveName())
            ->whereNull('finished_at')
            ->update([
                'status' => 'processed',
                'finished_at' => now(),
            ]);
    }
}
