<?php

namespace App\Listeners;

use Illuminate\Queue\Events\JobFailed;
use App\Models\JobMonitoring;

class JobFailedListener
{
    public function handle(JobFailed $event)
    {
        JobMonitoring::where('job_name', $event->job->resolveName())
            ->whereNull('failed_at')
            ->update([
                'status' => 'failed',
                'failed_at' => now(),
                'exception' => $event->exception->getMessage(),
            ]);
    }
}
