<?php

namespace App\Jobs;

use App\Models\HostNode;
use App\Models\FirewallRule;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;
use phpseclib3\Net\SSH2;

class SyncFirewallRules implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $hostNode;

    /**
     * Create a new job instance.
     *
     * @param HostNode $hostNode
     */
    public function __construct(HostNode $hostNode)
    {
        $this->hostNode = $hostNode;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        // Получаем все правила фаерволла
        $rules = FirewallRule::all();

        $commands = [];
        foreach ($rules as $rule) {
            $action = $rule->action === 'allow' ? 'ACCEPT' : 'DROP';
            $ip = $rule->ip_address ? "-s {$rule->ip_address}" : '';
            $commands[] = "sudo iptables -A INPUT -p {$rule->protocol} --dport {$rule->port} {$ip} -j {$action}";
        }

        // Подключаемся к узлу по SSH и применяем правила
        $ssh = new SSH2($this->hostNode->ip_address);
        if ($ssh->login($this->hostNode->ssh_username, $this->hostNode->ssh_password)) {
            foreach ($commands as $command) {
                $ssh->exec($command);
            }
            Log::info("Firewall rules synchronized for node: " . $this->hostNode->name);
        } else {
            Log::error("Failed to synchronize firewall rules for node: " . $this->hostNode->name);
        }
    }
}

