<?php

namespace App\Jobs;

use App\Models\HostNode;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Http;

class StartVirtualMachineJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $hostNode;
    protected $vmName;

    /**
     * Create a new job instance.
     *
     * @param HostNode $hostNode
     * @param string $vmName
     */
    public function __construct(HostNode $hostNode, string $vmName)
    {
        $this->hostNode = $hostNode;
        $this->vmName = $vmName;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $response = Http::withHeaders([
            'Authorization' => 'Bearer ' . $this->hostNode->auth_key,
        ])->post("http://{$this->hostNode->ip_address}:1515/server/start", [
            'name' => $this->vmName,
        ]);

        if ($response->successful()) {
            // Логика успешного выполнения, можно обновить статус ВМ в базе данных
            // Пример: VirtualMachine::where('name', $this->vmName)->update(['status' => 'running']);
        } else {
            // Обработка ошибок
            // Пример: VirtualMachine::where('name', $this->vmName)->update(['status' => 'error']);
        }
    }
}
