<?php

namespace App\Jobs;

use App\Models\VirtualMachine;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Http;

class LiveMigrateVirtualMachine implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $virtualMachine;
    protected $targetNode;

    /**
     * Create a new job instance.
     */
    public function __construct(VirtualMachine $virtualMachine, $targetNode)
    {
        $this->virtualMachine = $virtualMachine;
        $this->targetNode = $targetNode;
    }

    /**
     * Execute the job.
     */
    public function handle()
    {
        $sourceNode = $this->virtualMachine->node;

        // Отправляем запрос агенту на источнике для выполнения live-миграции
        $url = "http://{$sourceNode->ip_address}:{$sourceNode->agent_port}/server/live-migrate";
        Http::post($url, [
            'name' => $this->virtualMachine->vm_name,
            'target_node_ip' => $this->targetNode->ip_address,
        ]);

        // Обновляем узел ВМ в базе данных
        $this->virtualMachine->update(['node_id' => $this->targetNode->id]);
    }
}
