<?php

namespace App\Jobs;

use App\Models\TemplateOS;
use GuzzleHttp\Client;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Storage;

class DownloadOSTemplate implements ShouldQueue
{
    use InteractsWithQueue, Queueable, SerializesModels;

    protected $os;

    public function __construct(TemplateOS $os)
    {
        $this->os = $os;
    }

    public function handle()
    {
        // Скачивание архива ОС
        $client = new Client();
        $archiveUrl = $this->os->repository_link . '/' . $this->os->archive_name;
        $archivePath = storage_path('app/os/' . $this->os->archive_name);

        try {
            $client->get($archiveUrl, ['sink' => $archivePath]);

            // Логика распаковки архива
            $extractedPath = storage_path('app/os/' . $this->os->name);
            if (!is_dir($extractedPath)) {
                mkdir($extractedPath, 0755, true);
            }
            $zip = new \ZipArchive;
            if ($zip->open($archivePath) === true) {
                $zip->extractTo($extractedPath);
                $zip->close();
            }

            // Обновляем статус ОС
            $this->os->status = 'downloaded';
            $this->os->save();
        } catch (\Exception $e) {
            // Обработка ошибок
            $this->os->status = 'failed';
            $this->os->save();
        }
    }
}

