<?php

namespace App\Jobs;

use App\Models\TemplateOS;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Http;

class DownloadAndInstallOs implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $templateOs;

    public function __construct(TemplateOS $templateOs)
    {
        $this->templateOs = $templateOs;
    }

    public function handle()
    {
        $repositoryUrl = $this->templateOs->repository->url;
        $archiveUrl = $repositoryUrl . '/' . $this->templateOs->name . '.tar.gz';
        $localPath = storage_path('os/' . $this->templateOs->name . '.tar.gz');

        // Шаг 1: Скачивание архива ОС
        $response = Http::get($archiveUrl);
        Storage::put('os/' . $this->templateOs->name . '.tar.gz', $response->body());

        // Шаг 2: Распаковка архива
        $this->extractArchive($localPath);

        // Шаг 3: Обновление статуса ОС
        $this->templateOs->status = 'installed';
        $this->templateOs->save();
    }

    private function extractArchive($path)
    {
        // Пример распаковки архива tar.gz
        $phar = new \PharData($path);
        $phar->decompress(); // Распаковываем архив

        // Извлечение файлов
        $phar->extractTo(storage_path('os/' . $this->templateOs->name));
    }
}
