<?php

namespace App\Jobs;

use App\Models\TemplateOS;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Storage;

class DeleteOsJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $templateOs;

    public function __construct(TemplateOS $templateOs)
    {
        $this->templateOs = $templateOs;
    }

    public function handle()
    {
        // Удаление файлов ОС
        $osPath = storage_path('os/' . $this->templateOs->name);
        if (Storage::exists($osPath)) {
            Storage::deleteDirectory($osPath);
        }

        // Обновление статуса ОС
        $this->templateOs->status = 'available';
        $this->templateOs->save();
    }
}

