<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CheckIpRestriction
{
    public function handle(Request $request, Closure $next)
    {
        $user = Auth::user();
        $allowedIps = explode(',', $user->ip_restrictions);

        if (!empty($user->ip_restrictions) && !in_array($request->ip(), $allowedIps)) {
            return redirect()->route('login')->withErrors('Ваш IP-адрес не разрешен для входа в систему.');
        }

        return $next($request);
    }
}
