<?php

namespace App\Http\Controllers;

use App\Models\Pool;
use App\Models\VirtualMachineTemplate;
use App\Models\StoragePool;
use Illuminate\Http\Request;

class VirtualMachineTemplateController extends Controller
{
    public function index()
    {
        $templates = VirtualMachineTemplate::all();
        return view('templates.index', compact('templates'));
    }

    public function create()
    {
        $storagePools = Pool::all();
        return view('templates.create', compact('storagePools'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'template_name' => 'required|string|unique:virtual_machine_templates',
            'cpu' => 'required|integer|min:1',
            'memory' => 'required|integer|min:1',
            'disk_size' => 'required|integer|min:1',
            'os_type' => 'required|string',
            'network_bridge' => 'required|string',
            'cpu_emulation' => 'required|string',
            'network_model' => 'required|string',
            'storage_pool_id' => 'required|exists:pools,id',
            // Добавьте остальные правила валидации по необходимости
        ]);

        VirtualMachineTemplate::create($request->all());

        return redirect()->route('templates.index')->with('success', 'Шаблон виртуальной машины успешно создан.');
    }

    public function edit(VirtualMachineTemplate $template)
    {
        $storagePools = Pool::all();
        return view('templates.edit', compact('template', 'storagePools'));
    }

    public function update(Request $request, VirtualMachineTemplate $template)
    {
        $request->validate([
            'template_name' => 'required|string|unique:virtual_machine_templates,template_name,' . $template->id,
            'cpu' => 'required|integer|min:1',
            'memory' => 'required|integer|min:1',
            'disk_size' => 'required|integer|min:1',
            'os_type' => 'required|string',
            'network_bridge' => 'required|string',
            'cpu_emulation' => 'required|string',
            'network_model' => 'required|string',
            'storage_pool_id' => 'required|exists:pools,id',
            // Добавьте остальные правила валидации по необходимости
        ]);

        $template->update($request->all());

        return redirect()->route('templates.index')->with('success', 'Шаблон виртуальной машины успешно обновлён.');
    }

    public function destroy(VirtualMachineTemplate $template)
    {
        $template->delete();
        return redirect()->route('templates.index')->with('success', 'Шаблон виртуальной машины успешно удалён.');
    }
}
