<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rules\Password;

class UserSettingsController extends Controller
{
    public function showSettings()
    {
        return view('user.settings');
    }

    public function updatePassword(Request $request)
    {
        $request->validate([
            'current_password' => ['required', 'current_password'],
            'new_password' => ['required', 'confirmed', Password::min(8)],
        ]);

        $user = Auth::user();
        $user->password = Hash::make($request->new_password);
        $user->save();

        return redirect()->route('user.settings')->with('success', 'Пароль успешно обновлен.');
    }

    public function updateTwoFactor(Request $request)
    {
        $request->validate([
            'two_factor' => 'required|boolean',
        ]);

        $user = Auth::user();
        $user->two_factor = $request->two_factor;
        $user->save();

        return redirect()->route('user.settings')->with('success', 'Двухфакторная аутентификация обновлена.');
    }

    public function updateIpRestrictions(Request $request)
    {
        $request->validate([
            'ip_restrictions' => 'nullable|string',
        ]);

        $user = Auth::user();
        $user->ip_restrictions = $request->ip_restrictions;
        $user->save();

        return redirect()->route('user.settings')->with('success', 'Ограничения по IP обновлены.');
    }
}
