<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Setting;
use App\Models\Pool;
use App\Models\Repository;

class SettingsController extends Controller
{
    public function index()
    {
        // Получаем все настройки
        $settings = Setting::all();

        // Получаем текущий пул
        $pools = Pool::all(); // Если ожидается только один пул, можно использовать first() или find()

        // Получаем все репозитории
        $repositories = Repository::all();

        return view('settings.index', compact('settings', 'pools', 'repositories'));
    }

    public function update(Request $request)
    {
        // Сохранение общих настроек
        foreach ($request->input('settings', []) as $key => $value) {
            Setting::updateOrCreate(['key' => $key], ['value' => $value]);
        }

        // Сохранение настроек пула
        $poolData = $request->input('pool', []); // Используем пустой массив по умолчанию
        foreach ($poolData as $id => $data) {
            Pool::where('id', $id)->update($data);
        }

        return redirect()->back()->with('success', 'Settings updated successfully');
    }

    public function create(Request $request)
    {
        return view('settings.create');
    }

    public function store(Request $request)
    {
        // Валидация входных данных
        $request->validate([
            'key' => 'required|unique:settings',
            'value' => 'required',
        ]);

        // Создание новой настройки
        Setting::create($request->only(['key', 'value']));

        return redirect()->route('settings.index')->with('success', 'Setting created successfully');
    }

    public function updatePanel()
    {
        return redirect()->back()->with('success', 'Панель успешно обновлена.');
    }

    public function checkUpdate()
    {
        // Пример запроса для получения информации об обновлениях
        $response = Http::get('https://example.com/api/version'); // Пример API для проверки обновлений
        $currentVersion = config('app.version');
        $latestVersion = $response->json('version');

        if ($latestVersion > $currentVersion) {
            return redirect()->back()->with('update_available', true);
        }

        return redirect()->back()->with('success', 'Панель обновлена до последней версии.');
    }
}


