<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class SessionController extends Controller
{

//    public function __construct()
//    {
//        // Ограничиваем доступ к просмотру сессий
//        $this->middleware('can:view-sessions')->only(['index']);
//        // Ограничиваем доступ к завершению сессий
//        $this->middleware('can:delete-sessions')->only(['destroy']);
//    }

    public function index()
    {
        // Получаем активные сессии и присоединяем данные пользователя
        $sessions = DB::table('sessions')
            ->join('users', 'sessions.user_id', '=', 'users.id')
            ->select('sessions.*', 'users.name', 'users.email')
            ->get();

        return view('sessions.index', compact('sessions'));
    }

    public function destroy($id)
    {
        // Удаление сессии
        DB::table('sessions')->where('id', $id)->delete();

        return redirect()->route('sessions.index')->with('success', 'Сессия завершена.');
    }
}
