<?php

namespace App\Http\Controllers;

use App\Models\Repository;
use Illuminate\Http\Request;

class RepositoryController extends Controller
{
    // Добавление нового репозитория
    public function store(Request $request)
    {
        $request->validate([
            'url' => 'required|url',
        ]);

        // Создание нового репозитория
        Repository::create(['url' => $request->url, 'name' => basename($request->url)]);

        return redirect()->route('settings.index')->with('success', 'Репозиторий добавлен успешно.');
    }

    // Удаление репозитория
    public function destroy($id)
    {
        $repository = Repository::findOrFail($id);
        $repository->delete();

        return redirect()->route('settings.index')->with('success', 'Репозиторий удален успешно.');
    }
}
