<?php

namespace App\Http\Controllers;

use App\Models\HostNode;
use App\Models\NodeStats;
use Illuminate\Http\Request;

class NodeMetricsController extends Controller
{
    /**
     * Store metrics from Go agent.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(Request $request)
    {
        // Валидация входящих данных
        $data = $request->validate([
            'total_disk' => 'nullable|integer',
            'free_disk' => 'nullable|integer',
            'total_memory' => 'nullable|integer',
            'free_memory' => 'nullable|integer',
            'cpu_usage' => 'nullable|numeric',
            'load_average' => 'nullable|numeric',
            'incoming_traffic' => 'nullable|integer',
            'outgoing_traffic' => 'nullable|integer',
            'agent_version' => 'nullable|string',
            'libvirt_version' => 'nullable|string',
        ]);

        // Определение узла
        $node = HostNode::where('ip_address', $request->ip())->first();

        if (!$node) {
            return response()->json(['error' => 'Node not found'], 404);
        }

        // Сохранение метрик узла
        NodeStats::create([
            'node_id' => $node->id,
            'cpu_usage' => $data['cpu_usage'] ?? null,
            'memory_usage' => $data['total_memory'] ? ($data['total_memory'] - $data['free_memory']) / $data['total_memory'] * 100 : null,
        ]);

        // Обновление данных узла
        $node->update([
            'total_memory' => $data['total_memory'] ?? $node->total_memory,
            'free_memory' => $data['free_memory'] ?? $node->free_memory,
            'total_disk' => $data['total_disk'] ?? $node->total_disk,
            'free_disk' => $data['free_disk'] ?? $node->free_disk,
            'agent_version' => $data['agent_version'] ?? $node->agent_version,
            'libvirt_version' => $data['libvirt_version'] ?? $node->libvirt_version,
            'last_checked_at' => now(),
        ]);

        return response()->json(['message' => 'Metrics stored successfully'], 200);
    }
}
