<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;

class LanguageController extends Controller
{
    public function switchLanguage($lang)
    {
        // Проверка на поддерживаемый язык
        if (in_array($lang, ['en', 'ru'])) {
            Session::put('locale', $lang);
        }
        return Redirect::back();
    }
}

