<?php

namespace App\Http\Controllers;

use App\Models\HostNode;
use App\Jobs\SyncFirewallRules;
use Illuminate\Http\Request;

class FirewallController extends Controller
{
    public function sync()
    {
        $nodes = HostNode::all();

        foreach ($nodes as $node) {
            SyncFirewallRules::dispatch($node);
        }

        return redirect()->back()->with('success', 'Firewall rules are being synchronized.');
    }
}
