<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\HostNode;
use App\Jobs\CheckNodeAvailability;

class CheckNodesAvailability extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'nodes:check-availability';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Check availability of cluster nodes';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $nodes = HostNode::where('status', '!=', 'inactive')->get();

        foreach ($nodes as $node) {
            CheckNodeAvailability::dispatch($node);
        }

        $this->info('Node availability check dispatched for all active nodes.');
        return Command::SUCCESS;
    }
}

